-- maybe place stuff like this into an include type file.
tabbyDefs = { NEXT=1, BACK=2, CANCEL=3, INSTALL=4, DECLINED=5,
    PREINSTALL=6, POSTINSTALL=7, FINISH=8 };
    
-- sys = luajava.bindClass("java.lang.System");
-- print ( "getProperty: " .. sys:getProperty("java.ext.dirs") );

-- So that we can access the static objects in the SWT class.
-- Had to change the next line from luajava.bindClass to luajava.newInstance for gcj to work, the
-- luajava.bindClass() seems to only work for java.lang.??? classes under gcj.
swt = luajava.newInstance("org.eclipse.swt.SWT");

-- print("Create Tabby");

function Split(str, delim, maxNb)
    -- Eliminate bad cases...
    if string.find(str, delim) == nil then
        return { str }
    end
    if maxNb == nil or maxNb < 1 then
        maxNb = 0    -- No limit
    end
    local result = {}
    local pat = "(.-)" .. delim .. "()"
    local nb = 0
    local lastPos
    for part, pos in string.gfind(str, pat) do
        nb = nb + 1
        result[nb] = part
        lastPos = pos
        if nb == maxNb then break end
    end
    -- Handle the last field
    if nb ~= maxNb then
        result[nb + 1] = string.sub(str, lastPos)
    end
    return result
end

-- *** Starts the code that controls install ***

-- panelOrder is a list of panels in the order to be shown separated by commas.
po = Split(tabbyTable.panelOrder, ",", 30);

-- LUA does not have any bitwise operators, so use Java's
-- The BitWise class currently knows how to OR and AND integers.
-- BitWise.binaryOr and BitWise.binaryAnd

bw = luajava.newInstance("com.tabby.BitWise");
style = bw:binaryOr(swt.NO_BACKGROUND, swt.NO_TRIM);

-- com.Tabby constructor you need to pass the following to newInstance
-- ClassName - name of main parent window.
-- Display object past in from Java
-- Window trim style, values are xor together
-- panel name to display

t = luajava.newInstance("com.tabby.Tabby", tabbyTable.display, style, "splashScreen");

-- Passing a second argument controls how long a panel will be displayed
-- before it is brought down by the Tabby program
-- The delay is in milliseconds, 1000 = 1 second
t:open(tabbyTable.display, 3000);
t:dispose();

-- show a screen so user can select a language.
t = luajava.newInstance("com.tabby.Tabby", tabbyTable.display, swt.SHELL_TRIM, "langScreen");
t:open(tabbyTable.display);
t:dispose();

if panelTable.action == tabbyDefs.CANCEL then
    exit();
end

-- width and height of window is defined in tabbycfg.ini file.
idx = 1;        -- use idx cause you can not change value of x in for loop.
for x = 1, 30, 1 do
    v = po[idx];
    if v == nil then
        break;
    end
    
    t = luajava.newInstance("com.tabby.Tabby", tabbyTable.display, swt.SHELL_TRIM, v);
    t:open(tabbyTable.display);
    t:dispose();
    
    -- print("Panel (action): " .. v .. " = (" .. panelTable.action .. ")");
    
    if panelTable.action == tabbyDefs.CANCEL then
        -- print("CANCELED");
        break;
    elseif panelTable.action == tabbyDefs.DECLINED then
        -- print("DECLINED");
        break;
    elseif panelTable.action == tabbyDefs.BACK then
        if idx > 1 then
            idx = idx - 1;
        end
    elseif panelTable.action == tabbyDefs.PREINSTALL then
        idx = idx + 1;
    elseif panelTable.action == tabbyDefs.POSTINSTALL then
        idx = idx + 1;
    elseif panelTable.action == tabbyDefs.FINISH then
        -- print("FINISHED");
        break;
    elseif panelTable.action == tabbyDefs.NEXT then
        idx = idx + 1;
    end
end

-- Do the install if the user picked that action type.
if panelTable.action == tabbyDefs.INSTALL then
    print("Off doing install, not really");
end
